<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'notes', 'order_num', 'user_id', 'provider_id', 'vat_per', 'vat_amount', 'final_total', 'admin_commission_per', 'admin_commission', 'status', 'pay_type', 'pay_status', 'pay_data', 'lat', 'lng', 'city', 'map_desc', 'user_delete', 'provider_delete', 'admin_delete', 'day', 'time', 'service_type', 'maintenance_price', 'products_price', 'type', 'order_offer_id');

    public function categories()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function problems()
    {
        return $this->hasMany('App\Models\Problem');
    }

    public function photos()
    {
        return $this->morphMany('App\Models\Photo', 'photable');
    }

    public function orderOffers()
    {
        return $this->hasMany('App\Models\OrderOffer');
    }

    public function products()
    {
        return $this->hasMany('App\Models\OrderProduct');
    }

    public function orderOffer()
    {
        return $this->hasOne('App\Models\OrderOffer');
    }

}